<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterProjectTimeLogTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('project_time_logs', function (Blueprint $table) {
            $table->integer('task_id')->unsigned()->nullable()->default(null)->after('project_id');
            $table->foreign('task_id')->references('id')->on('tasks')->onDelete('cascade')->onUpdate('cascade');
        });

        DB::statement('ALTER TABLE `project_time_logs` CHANGE `project_id` `project_id` INT(10) UNSIGNED NULL DEFAULT NULL');

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('project_time_logs', function (Blueprint $table) {
            $table->dropForeign(['task_id']);
            $table->dropColumn(['task_id']);
        });
    }

}
